#include <cstdint>
#include <iostream>
#include <map>
#include <vector>

using std::int64_t;

int main()
{
    int64_t N, K, sum = 0;
    std::cin >> N >> K;

    std::vector<std::map<int64_t, int64_t>> distributions(K);
    std::vector<int64_t>                    groups(K);
    std::map<int64_t, int64_t>              frequencies;

    for (int64_t i = 0; i < N; ++i)
    {
        int64_t w;
        std::cin >> w;
        sum += w;
        groups[i % K] += w;
        ++distributions[i % K][w];
        ++frequencies[w];
    }

    if (sum % K)
    {
        std::cout << "0\n";
        return 0;
    }

    auto average = sum / K;

    std::vector<int64_t> not_average;
    for (int64_t i = 0; i < K; ++i)
    {
        if (groups[i] != average)
            not_average.push_back(i);
    }

    int64_t solution = 0;

    // Mozemo da zamenimo bilo koji par elemenata iste vrednosti, ili
    // bilo koja dva elementa iz iste grupe
    if (not_average.size() == 0)
    {
        solution = K * (N / K) * (N / K - 1) / 2;
        for (auto const& f : frequencies)
            solution += (f.second * (f.second - 1)) / 2;
        // Neke smo racunali duplo (iste vrednosti iz istih grupa)
        for (auto const& d : distributions)
            for (auto const& f : d)
                solution -= (f.second * (f.second - 1)) / 2;
    }
    // Moramo da zamenimo elemente iz ove dve grupe
    else if (not_average.size() == 2)
    {
        auto const& distribution_a = distributions[not_average[0]];
        auto&       distribution_b = distributions[not_average[1]];

        int64_t delta = average - groups[not_average[0]];

        for (auto const& d : distribution_a)
        {
            solution += d.second * distribution_b[d.first + delta];
        }
    }

    std::cout << solution << "\n";
}
